'''
*****************ORIGINAL XBOX OFFLINE BATCH DLC SIGNER*****************
https://digiex.net/threads/original-xbox-offline-batch-dlc-signer.16027/

Written by: sinikal6969
Based on work by: Rocky5 & Harcroft

How to use the script:
1) Unzip to your XBMC4Gamers scripts folder.
2) Log into your profile.
3) Hit the black button on your controller
4) Choose Settings->Skin Settings->Scripts->Scripts Menu
5) Click on the offline_dlc_signer script
6) Select the root folder containing all the DLC you want to sign. (eg. E:\TDATA).
7) Click OK
8) All your DLC is signed!

*****************ORIGINAL XBOX OFFLINE BATCH DLC SIGNER*****************
'''
import fileinput, hashlib, hmac, logging, operator, os, shutil, struct, time, traceback, xbmc, xbmcgui
dialog = xbmcgui.Dialog()
tprogress = xbmcgui.DialogProgress()
dprogress = xbmcgui.DialogProgress()

# vars			
hashlibsha1 = hashlib.sha1			
try:
	current_skin_version = int(xbmc.getLocalizedString(39999)[-7:].replace(".",""))
except:
	current_skin_version = int(xbmc.getLocalizedString(31000)[-7:].replace(".",""))
		
try:		

	# User selects file path containing folders with DLC to sign (eg. E:\TDATA)
	Root_Dir = dialog.browse( 0,"Select a folder","files" )
	if Root_Dir !="":
		Root_Directory = Root_Dir
	#	Root_Directories = [Root_Dir]
	#else:
	#	Root_Directories = ["E:/TDATA/","F:/TDATA/"]			
		
	#for Root_Directory in Root_Directories:
		dprogress.update(0)	
		dprogress.create("DLC SIGNER","","Initializing" )				
		tcountlist=0
		titlecount=0			
		for Item in sorted( os.listdir( Root_Directory ) ):
			if os.path.isdir( os.path.join ( Root_Directory, Item ) ):				
				titlecount=titlecount+1						
		# Loop through DLC folders
		for Item in sorted( os.listdir( Root_Directory ) ):
			# For each DLC directory (eg. E:\TDATA\4d530041) found...
			if os.path.isdir( os.path.join ( Root_Directory, Item ) ):							
				tcountlist=tcountlist+1
				dprogress.update(( tcountlist * 100 ) / titlecount,"Processing DLC " + Item, "This can take some time, please be patient." )	    
				TitleDir = os.path.join ( Root_Directory, Item )												
				titleid = ""			
				xbmcgui.Window(xbmcgui.getCurrentWindowId()).setProperty("MyScript.ExternalRunning", "False")				
				try:								
					xbmc.executebuiltin('Skin.SetString(DisableCancel,Disabled)')																													
					# Get the HDD Hardware (not ATA Password) Key
					# Had to use this while loop to get the HDD key as it will be Busy for a second or two.
					while True:
						key = xbmc.getInfoLabel('system.hddlockkey')
						time.sleep(1)
						if key != 'Busy':
							hddkey = key.decode('hex')									
							break
					# Walk the folder sub-tree and find all folders and files
					for folder, subfolder, file in os.walk( TitleDir ):
						# For every folder or file that you found
						for xbxfile in file:
							xbxfile = xbxfile.lower()
							# If this file is called contentmeta.xbx (this is the only file that needs signing in $c or $u)
							if xbxfile == "contentmeta.xbx":
								contentmetafile = os.path.join( folder, xbxfile )							
								filesize = os.path.getsize(contentmetafile)							
								readxbx = open(contentmetafile, 'r+b')
								# Byte 0x20 appears to signify the difference between On-Disc Content (0x00) and Installed DLC (0x01)
								# All DLC installed to HDD must have this byte set to 0x01. Must be done before signing to calculate the correct signature.
								readxbx.seek(32,0)
								readxbx.write(bytearray.fromhex("01").decode())							
								readxbx.seek(0,0)
								filedata = readxbx.read(filesize)							
								# The content header size (which points to the data that needs to be hashed to calculate the correct signature) is stored at bytes 24:28
								headersize = struct.unpack('I', filedata[24:28])[0]							
								# The title ID is stored in reverse byte order at bytes 36:40
								titleid = filedata[36:40]							
								# Compute the HMAC key using the title id and HDD key 
								hmacKey = hmac.new(hddkey, titleid, hashlibsha1).digest()[0:20]							
								# Compute the content signature using the hmacKey and filedata (which starts at byte 20 and extends for length of previously calculated headersize
								contentSignature = hmac.new(hmacKey, filedata[20:headersize], hashlibsha1).digest()[0:20]							
								# Write the calculated content signature at the beginning of the file
								readxbx.seek(0,0)															
								readxbx.write(contentSignature)															
						xbmc.executebuiltin('Skin.SetString(DisableCancel,)')																							
				except Exception as err:
					print "Error 2:"; logging.error(traceback.format_exc())
					if dprogress.iscanceled():
						dprogress.close()									
						dialog.ok("ERROR","","Operation Cancelled")																
					else:
						dprogress.close()
						dialog.ok("ERROR","","Error Encountered")																
		dprogress.close()
		xbmc.executebuiltin('Skin.SetString(DisableCancel,)')																				
except Exception as err:
	print "Error 2:"; logging.error(traceback.format_exc())
	if dprogress.iscanceled():
		dprogress.close()
		dialog.ok("ERROR","","Operation Cancelled")
	else:
		dprogress.close()
	dialog.ok("ERROR","","Error Encountered")

dialog.ok("SUCCESS","","Signing Complete")
# Used to zero the progress bar after everything is done
try:
	dprogress.update(0)
except:
	pass